'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const useControllableState = require('../hooks/useControllableState.js');
const useId = require('../hooks/useId.js');
const FieldContext = require('../Field/FieldContext.js');
const Typography = require('../Typography/Typography.js');
const Flex = require('../Flex/Flex.js');
const utils = require('../themes/utils.js');
const Field = require('../Field/Field.js');
const FieldLabel = require('../Field/FieldLabel.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');
const TextButton = require('../TextButton/TextButton.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

/**
 * TODO: This should probably follow the switch button pattern
 * as seen – https://www.w3.org/WAI/ARIA/apg/patterns/switch/examples/switch-button/
 */
const ToggleInputInput = React__namespace.forwardRef(({ offLabel, onLabel, disabled, checked: checkedProp, onChange, size = 'M', ...props }, forwardedRef) => {
    const [checked = false, setChecked] = useControllableState.useControllableState({
        prop: checkedProp,
    });
    const { error, id, name, required } = FieldContext.useField();
    const isFalseyChecked = checked !== null && !checked;
    const hintId = `${id}-hint`;
    const errorId = `${id}-error`;
    return (jsxRuntime.jsxs(ToggleWrapper, { position: "relative", hasRadius: true, padding: 1, background: disabled ? 'neutral150' : 'neutral100', borderStyle: "solid", borderWidth: "1px", borderColor: "neutral200", wrap: "wrap", cursor: disabled ? 'not-allowed' : 'pointer', hasError: Boolean(error), children: [jsxRuntime.jsx(ToggleOption, { hasRadius: true, flex: "1 1 50%", paddingTop: 2, paddingBottom: 2, paddingLeft: 3, paddingRight: 3, justifyContent: "center", background: disabled && isFalseyChecked ? 'neutral200' : isFalseyChecked ? 'neutral0' : 'transparent', borderColor: disabled && isFalseyChecked
                    ? 'neutral300'
                    : isFalseyChecked
                        ? 'neutral200'
                        : disabled
                            ? 'neutral150'
                            : 'neutral100', size: size, children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : isFalseyChecked ? 'danger700' : 'neutral600', children: offLabel }) }), jsxRuntime.jsx(ToggleOption, { hasRadius: true, flex: "1 1 50%", paddingLeft: 3, paddingRight: 3, justifyContent: "center", background: disabled && checked ? 'neutral200' : checked ? 'neutral0' : 'transparent', borderColor: disabled && checked ? 'neutral300' : checked ? 'neutral200' : disabled ? 'neutral150' : 'neutral100', size: size, children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : checked ? 'primary600' : 'neutral600', children: onLabel }) }), jsxRuntime.jsx(Input, { ...props, ref: forwardedRef, onChange: (e) => {
                    setChecked(e.currentTarget.checked);
                    onChange?.(e);
                }, type: "checkbox", id: id, name: name, "aria-required": required, disabled: disabled, "aria-disabled": disabled, "aria-describedby": id ? `${hintId} ${errorId}` : undefined, checked: Boolean(checked) })] }));
});
const ToggleWrapper = styled__default.default(Flex.Flex) `
  ${utils.inputFocusStyle()}
`;
const ToggleOption = styled__default.default(Flex.Flex) `
  /**
    We declare the defined value because we want the height of the input when 
    the values are in a row to be 40px. But defining a height on the label
    would break the input when it wraps.
  */
  padding-top: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
  padding-bottom: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
`;
const Input = styled__default.default.input `
  height: 100%;
  left: 0;
  opacity: 0;
  position: absolute;
  top: 0;
  z-index: 0;
  width: 100%;
`;
const ToggleInput = React__namespace.forwardRef(({ disabled = false, error, hint, label, name, labelAction, required = false, id, onClear, clearLabel, checked, ...props }, forwardedRef) => {
    const generatedId = useId.useId(id);
    return (jsxRuntime.jsx(Field.Field, { name: name, hint: hint, error: error, id: generatedId, required: required, maxWidth: "320px", children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsxRuntime.jsxs(Flex.Flex, { children: [label ? jsxRuntime.jsx(FieldLabel.FieldLabel, { action: labelAction, children: label }) : null, clearLabel && onClear && checked !== null && !disabled && (jsxRuntime.jsx(ClearButton, { onClick: onClear, children: clearLabel }))] }), jsxRuntime.jsx(ToggleInputInput, { ref: forwardedRef, checked: checked, disabled: disabled, ...props }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});
const ClearButton = styled__default.default(TextButton.TextButton) `
  align-self: flex-end;
  margin-left: auto;
`;

exports.ToggleInput = ToggleInput;
