import { jsxs, jsx } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { inputFocusStyle } from '../themes/utils.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { useField } from '../Field/FieldContext.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { Typography } from '../Typography/Typography.mjs';

const Label = styled.label `
  position: relative;
  display: inline-block;
  z-index: 0;
  width: 100%;
`;
const ToggleCheckboxWrapper = styled(Box) `
  cursor: ${({ disabled }) => (disabled ? 'not-allowed' : undefined)};
  // Masks the background of each value
  overflow: hidden;
  flex-wrap: wrap;

  ${inputFocusStyle()}
`;
const ValueBox = styled(Flex).attrs({
    hasRadius: true,
}) `
  background-color: ${({ theme, checked, disabled }) => {
    if (checked) {
        return disabled ? theme.colors.neutral200 : theme.colors.neutral0;
    }
    return 'transparent';
}};
  border: 1px solid
    ${({ theme, checked, disabled }) => {
    if (checked && checked !== null) {
        return disabled ? theme.colors.neutral300 : theme.colors.neutral200;
    }
    return disabled ? theme.colors.neutral150 : theme.colors.neutral100;
}};
  position: relative;
  user-select: none;
  z-index: 2;
  flex: 1 1 50%;
  /**
    We declare the defined value because we want the height of the input when 
    the values are in a row to be 40px. But defining a height on the label
    would break the input when it wraps.
  */
  padding-top: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
  padding-bottom: ${({ size }) => `${size === 'S' ? '2px' : '6px'}`};
`;
/**
 * visually hiding the input without SR-only helps Android SR to provide information with touch and haptic
 */
const Input = styled.input `
  height: 100%;
  left: 0;
  opacity: 0;
  position: absolute;
  top: 0;
  z-index: 1;
  width: 100%;
`;
const ToggleCheckbox = React__default.forwardRef(({ size = 'M', onLabel, offLabel, children, checked = false, disabled = false, onChange, ...props }, ref) => {
    const { error, hint, id, name, required } = useField();
    const labelColor = 'neutral600';
    let offCheckboxLabelColor = !checked && checked !== null ? 'danger700' : labelColor;
    let onCheckboxLabelColor = checked ? 'primary600' : labelColor;
    const handleChange = (e) => {
        if (disabled)
            return;
        if (onChange) {
            onChange(e);
        }
    };
    // Ensuring we pass the right aria-describedby attribute to the Input component as
    // ToggleCheckbox is not using FieldInput which would allow us to pass on the error or hint with aria-describedby
    let ariaDescription;
    if (error) {
        ariaDescription = `${id}-error`;
    }
    else if (hint) {
        ariaDescription = `${id}-hint`;
    }
    return (jsxs(Label, { children: [jsx(VisuallyHidden, { children: children }), jsxs(ToggleCheckboxWrapper, { hasRadius: true, disabled: disabled, padding: 1, display: "flex", background: disabled ? 'neutral150' : 'neutral100', borderStyle: "solid", borderWidth: "1px", borderColor: "neutral200", hasError: Boolean(error), children: [jsx(ValueBox, { size: size, paddingLeft: 3, paddingRight: 3, justifyContent: "center", alignItems: "center", "aria-hidden": true, checked: checked === null ? false : !checked, disabled: disabled, children: jsx(Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : offCheckboxLabelColor, children: offLabel }) }), jsx(ValueBox, { size: size, paddingLeft: 3, paddingRight: 3, justifyContent: "center", alignItems: "center", "aria-hidden": true, checked: checked === null ? false : checked, disabled: disabled, children: jsx(Typography, { variant: "pi", fontWeight: "bold", textTransform: "uppercase", textColor: disabled ? 'neutral700' : onCheckboxLabelColor, children: onLabel }) }), jsx(Input, { type: "checkbox", "aria-disabled": disabled, "aria-describedby": ariaDescription, onChange: (e) => handleChange(e), name: name, ref: ref, "aria-required": required, ...props, checked: !(checked === null || !checked) })] })] }));
});
ToggleCheckbox.displayName = 'ToggleCheckbox';

export { ToggleCheckbox };
