import { jsx, jsxs } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { useId } from '../hooks/useId.mjs';
import { inputFocusStyle } from '../themes/utils.mjs';
import { Box } from '../Box/Box.mjs';
import { useField } from '../Field/FieldContext.mjs';
import { Field } from '../Field/Field.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';

const Wrapper = styled(Box) `
  ${inputFocusStyle()}
`;
const TextareaElement = styled(Box) `
  border: none;
  resize: none;

  ::placeholder {
    color: ${({ theme }) => theme.colors.neutral500};
    font-size: ${({ theme }) => theme.fontSizes[2]};
    color: ${({ theme }) => theme.colors.neutral500};
    opacity: 1;
  }

  &:focus-within {
    outline: none;
  }
`;
const TextareaInput = React__default.forwardRef(({ disabled, ...props }, ref) => {
    const { id, error, hint, required } = useField();
    const hasError = Boolean(error);
    let ariaDescription = hint ? `${id}-hint` : undefined;
    if (error) {
        ariaDescription = `${id}-error`;
    }
    return (jsx(Wrapper, { borderColor: hasError ? 'danger600' : 'neutral200', hasError: hasError, hasRadius: true, children: jsx(TextareaElement, { "aria-describedby": ariaDescription, "aria-invalid": hasError, "aria-required": required, as: "textarea", background: disabled ? 'neutral150' : 'neutral0', color: disabled ? 'neutral600' : 'neutral800', disabled: disabled, fontSize: 2, hasRadius: true, height: `${105 / 16}rem`, id: id, ref: ref, lineHeight: 4, padding: 4, width: "100%", ...props }) }));
});
const Textarea = React__default.forwardRef(({ name, hint, error, label, labelAction, id, required = false, children, value, ...props }, ref) => {
    const generatedId = useId(id);
    return (jsx(Field, { name: name, hint: hint, error: error, id: generatedId, required: required, children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label && jsx(FieldLabel, { action: labelAction, children: label }), jsx(TextareaInput, { ref: ref, value: children ?? value, ...props }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});

export { Textarea };
