import { jsx, jsxs } from 'react/jsx-runtime';
import { forwardRef, useRef, useImperativeHandle } from 'react';
import { useId } from '../hooks/useId.mjs';
import { Field } from '../Field/Field.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { FieldInput } from '../Field/FieldInput.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';

const TextInput = forwardRef(({ name, hint, error, label, labelAction, id, required, ...props }, ref) => {
    const generatedId = useId(id);
    const inputWrapperRef = useRef(null);
    const inputRef = useRef(null);
    if (!label && !props['aria-label']) {
        throw new Error('The TextInput component needs a "label" or an "aria-label" props');
    }
    /**
     * TODO: for V2, remove this.
     */
    useImperativeHandle(ref, () => ({
        input: inputRef,
        inputWrapperRef,
    }), []);
    return (jsx("div", { ref: inputWrapperRef, children: jsx(Field, { name: name, hint: hint, error: error, id: generatedId, required: required, children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label && jsx(FieldLabel, { action: labelAction, children: label }), jsx(FieldInput, { ref: inputRef, ...props }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }) }));
});
TextInput.displayName = 'TextInput';

export { TextInput };
