'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const useId = require('../hooks/useId.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const FieldLabel = require('../Field/FieldLabel.js');
const FieldInput = require('../Field/FieldInput.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');

const TextInput = React.forwardRef(({ name, hint, error, label, labelAction, id, required, ...props }, ref) => {
    const generatedId = useId.useId(id);
    const inputWrapperRef = React.useRef(null);
    const inputRef = React.useRef(null);
    if (!label && !props['aria-label']) {
        throw new Error('The TextInput component needs a "label" or an "aria-label" props');
    }
    /**
     * TODO: for V2, remove this.
     */
    React.useImperativeHandle(ref, () => ({
        input: inputRef,
        inputWrapperRef,
    }), []);
    return (jsxRuntime.jsx("div", { ref: inputWrapperRef, children: jsxRuntime.jsx(Field.Field, { name: name, hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label && jsxRuntime.jsx(FieldLabel.FieldLabel, { action: labelAction, children: label }), jsxRuntime.jsx(FieldInput.FieldInput, { ref: inputRef, ...props }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }) }));
});
TextInput.displayName = 'TextInput';

exports.TextInput = TextInput;
