import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { Loader } from '@strapi/icons';
import styled, { keyframes } from 'styled-components';
import { buttonFocusStyle } from '../themes/utils.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const rotation = keyframes `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`;
const LoadingWrapper = styled.div `
  animation: ${rotation} 2s infinite linear;
  will-change: transform;
`;
const TextButtonWrapper = styled(Flex) `
  border: none;

  &[aria-disabled='true'] {
    pointer-events: none;
    svg path {
      fill: ${({ theme }) => theme.colors.neutral600};
    }
  }

  svg path {
    fill: ${({ theme }) => theme.colors.primary600};
  }

  ${buttonFocusStyle}
`;
const TextButton = React.forwardRef(({ children, startIcon, endIcon, onClick, disabled = false, loading = false, ...props }, ref) => {
    const handleClick = onClick && !disabled ? onClick : undefined;
    const isDisabled = disabled || loading;
    return (jsxs(TextButtonWrapper, { ref: ref, "aria-disabled": isDisabled, onClick: handleClick, as: "button", type: "button", background: "transparent", gap: 2, ...props, children: [loading ? (jsx(LoadingWrapper, { "aria-hidden": true, children: jsx(Loader, {}) })) : (startIcon), jsx(Typography, { variant: "pi", textColor: isDisabled ? 'neutral600' : 'primary600', children: children }), endIcon] }));
});
TextButton.displayName = 'TextButton';

export { TextButton };
