import { jsxs, jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const Tag = ({ children, icon, disabled = false, onClick, ...props }) => {
    const handleClick = (e) => {
        if (disabled || !onClick)
            return;
        onClick(e);
    };
    return (jsxs(TagWrapper, { as: "button", background: disabled ? 'neutral200' : 'primary100', color: disabled ? 'neutral700' : 'primary600', paddingLeft: 3, paddingRight: 3, onClick: handleClick, "aria-disabled": disabled, disabled: disabled, borderWidth: "1px", borderStyle: "solid", borderColor: disabled ? 'neutral300' : 'primary200', hasRadius: true, height: `${32 / 16}rem`, gap: 2, ...props, children: [jsx(TagText, { "$disabled": disabled, variant: "pi", fontWeight: "bold", as: "span", children: children }), icon] }));
};
const TagWrapper = styled(Flex) `
  & > svg {
    height: ${8 / 16}rem;
    width: ${8 / 16}rem;
  }

  & > svg path {
    fill: ${({ theme, ...p }) => (p['aria-disabled'] ? theme.colors.neutral600 : theme.colors.primary600)};
  }
`;
const TagText = styled(Typography) `
  color: inherit;
  border-right: 1px solid ${({ theme, $disabled }) => ($disabled ? theme.colors.neutral300 : theme.colors.primary200)};
  padding-right: ${({ theme }) => theme.spaces[2]};
`;

export { Tag };
