'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');

const TabsContext = React.createContext({
    id: '',
    label: '',
    selectedTabIndex: 0,
    selectTabIndex() {
        throw new Error('TabsContext.selectTabIndex is not implemented.');
    },
});
const useTabs = () => React.useContext(TabsContext);

exports.TabsContext = TabsContext;
exports.useTabs = useTabs;
