import { jsx } from 'react/jsx-runtime';
import { Children, cloneElement } from 'react';
import { useTabs } from './TabsContext.mjs';

const TabPanels = ({ children, ...props }) => {
    const { id, selectedTabIndex } = useTabs();
    const childrenArray = Children.toArray(children)
        .map((node, index) => cloneElement(node, { id: `${id}-${index}` }))
        .filter((_, index) => index === selectedTabIndex);
    return jsx("div", { ...props, children: childrenArray });
};
const TabPanel = ({ id, ...props }) => {
    const tabId = `${id}-tab`;
    const tabPanelId = `${id}-tabpanel`;
    return jsx("div", { id: tabPanelId, role: "tabpanel", tabIndex: 0, "aria-labelledby": tabId, ...props });
};

export { TabPanel, TabPanels };
