import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { TabsContext } from './TabsContext.mjs';
import { useControllableState } from '../hooks/useControllableState.mjs';
import { useId } from '../hooks/useId.mjs';

const TabGroup = React.forwardRef(({ id, initialSelectedTabIndex, label, onTabChange, selectedTabIndex: selectedTabIndexProp, variant, ...props }, ref) => {
    const tabsId = useId(id);
    const [selectedTabIndex = 0, setSelectedTabIndex] = useControllableState({
        prop: selectedTabIndexProp,
        defaultProp: initialSelectedTabIndex,
        // @ts-expect-error
        onChange: onTabChange,
    });
    React.useImperativeHandle(ref, () => ({
        _handlers: { setSelectedTabIndex },
    }));
    const context = React.useMemo(() => ({ id: tabsId, selectedTabIndex, selectTabIndex: setSelectedTabIndex, label, variant, onTabChange }), [label, onTabChange, selectedTabIndex, tabsId, variant, setSelectedTabIndex]);
    return (jsx(TabsContext.Provider, { value: context, children: jsx("div", { ...props }) }));
});
TabGroup.displayName = 'TabGroup';

export { TabGroup };
