'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const TabsContext = require('./TabsContext.js');
const useControllableState = require('../hooks/useControllableState.js');
const useId = require('../hooks/useId.js');

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
    if (e) {
        for (const k in e) {
            if (k !== 'default') {
                const d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: () => e[k]
                });
            }
        }
    }
    n.default = e;
    return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);

const TabGroup = React__namespace.forwardRef(({ id, initialSelectedTabIndex, label, onTabChange, selectedTabIndex: selectedTabIndexProp, variant, ...props }, ref) => {
    const tabsId = useId.useId(id);
    const [selectedTabIndex = 0, setSelectedTabIndex] = useControllableState.useControllableState({
        prop: selectedTabIndexProp,
        defaultProp: initialSelectedTabIndex,
        // @ts-expect-error
        onChange: onTabChange,
    });
    React__namespace.useImperativeHandle(ref, () => ({
        _handlers: { setSelectedTabIndex },
    }));
    const context = React__namespace.useMemo(() => ({ id: tabsId, selectedTabIndex, selectTabIndex: setSelectedTabIndex, label, variant, onTabChange }), [label, onTabChange, selectedTabIndex, tabsId, variant, setSelectedTabIndex]);
    return (jsxRuntime.jsx(TabsContext.TabsContext.Provider, { value: context, children: jsxRuntime.jsx("div", { ...props }) }));
});
TabGroup.displayName = 'TabGroup';

exports.TabGroup = TabGroup;
