'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const RawTable = require('../RawTable/RawTable.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const TableContainer = styled__default.default(Box.Box) `
  overflow: hidden;
  border: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const TableWrapper = styled__default.default(RawTable.RawTable) `
  width: 100%;
  white-space: nowrap;
`;
const TableBox = styled__default.default(Box.Box) `
  &:before {
    // TODO: make sure to add a token for this weird stuff
    background: linear-gradient(90deg, #c0c0cf 0%, rgba(0, 0, 0, 0) 100%);
    opacity: 0.2;
    position: absolute;
    height: 100%;
    content: ${({ overflowing }) => (overflowing === 'both' || overflowing === 'left' ? "''" : undefined)};
    box-shadow: ${({ theme }) => theme.shadows.tableShadow};
    width: ${({ theme }) => theme.spaces[2]};
    left: 0;
  }

  &:after {
    // TODO: make sure to add a token for this weird stuff
    background: linear-gradient(270deg, #c0c0cf 0%, rgba(0, 0, 0, 0) 100%);
    opacity: 0.2;
    position: absolute;
    height: 100%;
    content: ${({ overflowing }) => (overflowing === 'both' || overflowing === 'right' ? "''" : undefined)};
    box-shadow: ${({ theme }) => theme.shadows.tableShadow};
    width: ${({ theme }) => theme.spaces[2]};
    right: 0;
    top: 0;
  }
`;
const ScrollContainer = styled__default.default(Box.Box) `
  overflow-x: auto;
`;
const Table = ({ footer, ...props }) => {
    const tableRef = React.useRef(null);
    const [overflowing, setOverflowing] = React.useState();
    const handleScroll = (e) => {
        const maxScrollLeft = e.target.scrollWidth - e.target.clientWidth;
        if (e.target.scrollLeft === 0) {
            setOverflowing('right');
            return;
        }
        if (e.target.scrollLeft === maxScrollLeft) {
            setOverflowing('left');
            return;
        }
        if (e.target.scrollLeft > 0) {
            setOverflowing('both');
        }
    };
    React.useEffect(() => {
        if (tableRef.current.scrollWidth > tableRef.current.clientWidth) {
            setOverflowing('right');
        }
    }, []);
    return (jsxRuntime.jsxs(TableContainer, { shadow: "tableShadow", hasRadius: true, background: "neutral0", children: [jsxRuntime.jsx(TableBox, { overflowing: overflowing, position: "relative", children: jsxRuntime.jsx(ScrollContainer, { ref: tableRef, onScroll: handleScroll, paddingLeft: 6, paddingRight: 6, children: jsxRuntime.jsx(TableWrapper, { ...props }) }) }), footer] }));
};

exports.Table = Table;
