'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Box = require('../Box/Box.js');
const Divider = require('../Divider/Divider.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const IconBox = styled__default.default(Box.Box) `
  height: ${24 / 16}rem;
  width: ${24 / 16}rem;
  border-radius: 50%;
  display: flex;
  justify-content: center;
  align-items: center;

  svg {
    height: ${10 / 16}rem;
    width: ${10 / 16}rem;
  }

  svg path {
    fill: ${({ theme }) => theme.colors.primary600};
  }
`;
// TODO: remove when the reset css button is merged
const ButtonBox = styled__default.default(Box.Box) `
  border-radius: 0 0 ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius};
  display: block;
  width: 100%;
  border: none;
`;
const TFooter = ({ children, icon, ...props }) => {
    return (jsxRuntime.jsxs("div", { children: [jsxRuntime.jsx(Divider.Divider, {}), jsxRuntime.jsx(ButtonBox, { as: "button", background: "primary100", padding: 5, ...props, children: jsxRuntime.jsxs(Flex.Flex, { children: [jsxRuntime.jsx(IconBox, { "aria-hidden": true, background: "primary200", children: icon }), jsxRuntime.jsx(Box.Box, { paddingLeft: 3, children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", fontWeight: "bold", textColor: "primary600", children: children }) })] }) })] }));
};

exports.TFooter = TFooter;
