'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const RawCell = require('../RawTable/RawCell.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const CellWrapper = styled__default.default(RawCell.RawTd) `
  vertical-align: middle;
  text-align: left;
  color: ${({ theme }) => theme.colors.neutral600};
  outline-offset: -4px;

  /**
  * Hack to make sure the checkbox looks aligned
  */
  input {
    vertical-align: sub;
  }
`;
const ActionWrapper = styled__default.default.span `
  svg {
    height: ${4 / 16}rem;
  }
`;
const Th = ({ children, action, ...props }) => {
    return (jsxRuntime.jsx(CellWrapper, { as: RawCell.RawTh, ...props, children: jsxRuntime.jsxs(Flex.Flex, { children: [children, jsxRuntime.jsx(ActionWrapper, { children: action })] }) }));
};
const Td = ({ children, ...props }) => {
    return jsxRuntime.jsx(CellWrapper, { ...props, children: children });
};

exports.Td = Td;
exports.Th = Th;
