import { jsxs, jsx } from 'react/jsx-runtime';
import { Dot } from '@strapi/icons';
import { NavLink } from 'react-router-dom';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { Flex } from '../Flex/Flex.mjs';

const SubNavLinkWrapper = styled(Box) `
  display: flex;
  align-items: center;
  justify-content: space-between;
  text-decoration: none;
  color: ${({ theme }) => theme.colors.neutral800};
  svg > * {
    fill: ${({ theme }) => theme.colors.neutral600};
  }

  &.active {
    ${({ theme }) => {
    return `
      background-color: ${theme.colors.primary100};
      border-right: 2px solid ${theme.colors.primary600};
      svg > * {
        fill: ${theme.colors.primary700};
      }
      ${Typography} {
        color: ${theme.colors.primary700};
        font-weight: 500;
      }
      `;
}}
  }

  &:focus-visible {
    outline-offset: -2px;
  }
`;
const CustomBullet = styled(Dot) `
  width: ${12 / 16}rem;
  height: ${4 / 16}rem;
  * {
    fill: ${({ theme, $active }) => ($active ? theme.colors.primary600 : theme.colors.neutral600)};
  }
`;
const IconWrapper = styled.div `
  svg {
    height: ${12 / 16}rem;
    width: ${12 / 16}rem;
  }
`;
const SubNavLink = ({ children, icon, withBullet = false, isSubSectionChild = false, ...props }) => {
    return (jsxs(SubNavLinkWrapper, { as: NavLink, icon: icon, background: "neutral100", paddingLeft: isSubSectionChild ? 9 : 7, paddingBottom: 2, paddingTop: 2, ...props, children: [jsxs(Flex, { children: [icon ? jsx(IconWrapper, { children: icon }) : jsx(CustomBullet, {}), jsx(Box, { paddingLeft: 2, children: jsx(Typography, { as: "span", children: children }) })] }), withBullet && (jsx(Box, { as: Flex, paddingRight: 4, children: jsx(CustomBullet, { "$active": true }) }))] }));
};

export { SubNavLink };
