'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const reactRouterDom = require('react-router-dom');
const styled = require('styled-components');
const Box = require('../Box/Box.js');
const Typography = require('../Typography/Typography.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const SubNavLinkWrapper = styled__default.default(Box.Box) `
  display: flex;
  align-items: center;
  justify-content: space-between;
  text-decoration: none;
  color: ${({ theme }) => theme.colors.neutral800};
  svg > * {
    fill: ${({ theme }) => theme.colors.neutral600};
  }

  &.active {
    ${({ theme }) => {
    return `
      background-color: ${theme.colors.primary100};
      border-right: 2px solid ${theme.colors.primary600};
      svg > * {
        fill: ${theme.colors.primary700};
      }
      ${Typography.Typography} {
        color: ${theme.colors.primary700};
        font-weight: 500;
      }
      `;
}}
  }

  &:focus-visible {
    outline-offset: -2px;
  }
`;
const CustomBullet = styled__default.default(icons.Dot) `
  width: ${12 / 16}rem;
  height: ${4 / 16}rem;
  * {
    fill: ${({ theme, $active }) => ($active ? theme.colors.primary600 : theme.colors.neutral600)};
  }
`;
const IconWrapper = styled__default.default.div `
  svg {
    height: ${12 / 16}rem;
    width: ${12 / 16}rem;
  }
`;
const SubNavLink = ({ children, icon, withBullet = false, isSubSectionChild = false, ...props }) => {
    return (jsxRuntime.jsxs(SubNavLinkWrapper, { as: reactRouterDom.NavLink, icon: icon, background: "neutral100", paddingLeft: isSubSectionChild ? 9 : 7, paddingBottom: 2, paddingTop: 2, ...props, children: [jsxRuntime.jsxs(Flex.Flex, { children: [icon ? jsxRuntime.jsx(IconWrapper, { children: icon }) : jsxRuntime.jsx(CustomBullet, {}), jsxRuntime.jsx(Box.Box, { paddingLeft: 2, children: jsxRuntime.jsx(Typography.Typography, { as: "span", children: children }) })] }), withBullet && (jsxRuntime.jsx(Box.Box, { as: Flex.Flex, paddingRight: 4, children: jsxRuntime.jsx(CustomBullet, { "$active": true }) }))] }));
};

exports.SubNavLink = SubNavLink;
