import { jsx, jsxs } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { Flex } from '../Flex/Flex.mjs';

const Bullet = styled.div `
  margin-right: ${({ theme }) => theme.spaces[3]};
  width: ${6 / 16}rem;
  height: ${6 / 16}rem;
  border-radius: 50%;
  background: ${({ theme, backgroundColor }) => theme.colors[backgroundColor]};
`;
const StatusWrapper = styled(Box) `
  ${Typography} {
    color: ${({ theme, textColor }) => theme.colors[textColor]};
  }
`;
const Status = ({ variant = 'primary', showBullet = true, size = 'M', children, ...props }) => {
    const backgroundColor = `${variant}100`;
    const borderColor = `${variant}200`;
    const bulletColor = `${variant}600`;
    const textColor = `${variant}600`;
    const paddingX = size === 'S' ? 2 : 5;
    const paddingY = size === 'S' ? 1 : 4;
    return (jsx(StatusWrapper, { borderColor: borderColor, textColor: textColor, background: backgroundColor, hasRadius: true, paddingTop: paddingY, paddingBottom: paddingY, paddingLeft: paddingX, paddingRight: paddingX, ...props, children: showBullet ? (jsxs(Flex, { children: [jsx(Bullet, { backgroundColor: bulletColor }), children] })) : (children) }));
};

export { Status };
