'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Box = require('../Box/Box.js');
const Typography = require('../Typography/Typography.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const Bullet = styled__default.default.div `
  margin-right: ${({ theme }) => theme.spaces[3]};
  width: ${6 / 16}rem;
  height: ${6 / 16}rem;
  border-radius: 50%;
  background: ${({ theme, backgroundColor }) => theme.colors[backgroundColor]};
`;
const StatusWrapper = styled__default.default(Box.Box) `
  ${Typography.Typography} {
    color: ${({ theme, textColor }) => theme.colors[textColor]};
  }
`;
const Status = ({ variant = 'primary', showBullet = true, size = 'M', children, ...props }) => {
    const backgroundColor = `${variant}100`;
    const borderColor = `${variant}200`;
    const bulletColor = `${variant}600`;
    const textColor = `${variant}600`;
    const paddingX = size === 'S' ? 2 : 5;
    const paddingY = size === 'S' ? 1 : 4;
    return (jsxRuntime.jsx(StatusWrapper, { borderColor: borderColor, textColor: textColor, background: backgroundColor, hasRadius: true, paddingTop: paddingY, paddingBottom: paddingY, paddingLeft: paddingX, paddingRight: paddingX, ...props, children: showBullet ? (jsxRuntime.jsxs(Flex.Flex, { children: [jsxRuntime.jsx(Bullet, { backgroundColor: bulletColor }), children] })) : (children) }));
};

exports.Status = Status;
