'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const theme = require('../helpers/theme.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

/**
 * Prevents these attributes from being spread on the DOM node
 */
const transientProps = {
    size: true,
    spacing: true,
};
const StackV = styled__default.default(Flex.Flex).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  & > * {
    margin-top: 0;
    margin-bottom: 0;
  }

  & > * + * {
    margin-top: ${({ theme: theme$1, spacing }) => theme.extractStyleFromTheme(theme$1.spaces, spacing, undefined)};
  }
`;
const StackH = styled__default.default(Flex.Flex).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  & > * {
    margin-left: 0;
    margin-right: 0;
  }

  & > * + * {
    margin-left: ${({ theme: theme$1, spacing }) => theme.extractStyleFromTheme(theme$1.spaces, spacing, undefined)};
  }
`;
const Stack = React.forwardRef(({ horizontal = false, spacing, size, ...props }, ref) => {
    if (size) {
        console.warn('Deprecation warning: Usage of "size" prop in Stack component is deprecated. This is discouraged and will be removed in the next major release. Please use "spacing" instead');
    }
    if (horizontal) {
        return jsxRuntime.jsx(StackH, { ref: ref, spacing: spacing || size, ...props });
    }
    return jsxRuntime.jsx(StackV, { direction: "column", alignItems: "stretch", ref: ref, spacing: spacing || size, ...props });
});
Stack.displayName = 'Stack';

exports.Stack = Stack;
