import { jsx, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import { Root, Trigger, Value, Portal, Content, Viewport, Item, ItemText } from './SelectParts.mjs';
import { stripReactIdOfColon } from '../helpers/strings.mjs';
import { useComposedRefs } from '../hooks/useComposeRefs.mjs';
import { useId } from '../hooks/useId.mjs';
import { useIntersection } from '../hooks/useIntersection.mjs';
import { Field } from '../Field/Field.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';
import { Box } from '../Box/Box.mjs';
import { Typography } from '../Typography/Typography.mjs';

const SingleSelect = React.forwardRef(({ error, hint, id, label, labelAction, required, selectButtonTitle: _deprecatedSelectButtonTitle, ...restProps }, forwardedRef) => {
    const generatedId = useId(id);
    /**
     * Because the trigger needs to be a `div` to allow the clear
     * button & tags to be clickable, we need to manually focus it.
     */
    const triggerRef = React.useRef(null);
    const handleFieldLabelClick = () => {
        triggerRef.current.focus();
    };
    const composedTriggerRefs = useComposedRefs(forwardedRef, triggerRef);
    return (jsx(Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label ? (jsx(FieldLabel, { onClick: handleFieldLabelClick, action: labelAction, children: label })) : null, jsx(SingleSelectInput, { label: label, id: generatedId, ref: composedTriggerRefs, required: required, ...restProps }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});
const SingleSelectInput = React.forwardRef(({ 'aria-label': ariaLabel, id, children, clearLabel = 'Clear', customizeContent, disabled, error, label, onChange, onClear, onCloseAutoFocus, onReachEnd, placeholder, required, selectButtonTitle: _deprecatedSelectButtonTitle, startIcon, size = 'M', value: passedValue, ...restProps }, forwardedRef) => {
    /**
     * These values are drawn out from the internals of the Radix component
     * We can then use them to react to visual changes for the component
     */
    const [internalValue, setInternalValue] = React.useState();
    const [internalIsOpen, setInternalIsOpen] = React.useState(false);
    const handleOpenChange = (open) => {
        setInternalIsOpen(open);
    };
    const handleOnClear = (e) => {
        if (onClear) {
            onClear(e);
        }
        if (!onChange) {
            setInternalValue('');
        }
    };
    const hintId = `${id}-hint`;
    const errorId = `${id}-error`;
    const handleValueChange = (value) => {
        /**
         * If it's being externally managed then we shouldn't
         * both setting our copy of the internal value.
         */
        if (onChange) {
            const shouldBeNumber = typeof passedValue === 'number';
            onChange(shouldBeNumber ? Number(value) : value);
        }
        else {
            setInternalValue(value);
        }
    };
    const viewportRef = React.useRef(null);
    const generatedIntersectionId = useId();
    const intersectionId = `intersection-${stripReactIdOfColon(generatedIntersectionId)}`;
    const handleReachEnd = (entry) => {
        if (onReachEnd) {
            onReachEnd(entry);
        }
    };
    useIntersection(viewportRef, handleReachEnd, {
        selectorToWatch: `#${intersectionId}`,
        /**
         * We need to know when the select is open because only then will viewportRef
         * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
         */
        skipWhen: !internalIsOpen,
    });
    const value = (typeof passedValue !== 'undefined' && passedValue !== null ? passedValue.toString() : internalValue) ?? '';
    return (jsxs(Root, { onOpenChange: handleOpenChange, disabled: disabled, required: required, onValueChange: handleValueChange, value: value, ...restProps, children: [jsx(Trigger, { ref: forwardedRef, "aria-label": label ?? ariaLabel, "aria-describedby": id ? `${hintId} ${errorId}` : undefined, id: id, startIcon: startIcon, size: size, hasError: Boolean(error), disabled: disabled, clearLabel: clearLabel, onClear: value && onClear ? handleOnClear : undefined, children: jsx(Value, { placeholder: placeholder, textColor: value ? 'neutral800' : 'neutral600', children: value && customizeContent ? customizeContent(value) : undefined }) }), jsx(Portal, { children: jsx(Content, { position: "popper", sideOffset: 4, onCloseAutoFocus: onCloseAutoFocus, children: jsxs(Viewport, { ref: viewportRef, children: [children, jsx(Box, { id: intersectionId, width: "100%", height: "1px" })] }) }) })] }));
});
const SingleSelectOption = React.forwardRef(({ value, startIcon, children, ...restProps }, ref) => {
    return (jsxs(Item, { ref: ref, value: value.toString(), ...restProps, children: [startIcon && (jsx(Box, { as: "span", "aria-hidden": true, children: startIcon })), jsx(Typography, { textColor: "neutral800", children: jsx(ItemText, { children: children }) })] }));
});

export { SingleSelect, SingleSelectInput, SingleSelectOption };
