'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const uiPrimitives = require('@strapi/ui-primitives');
const styled = require('styled-components');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const Flex = require('../Flex/Flex.js');
const Box = require('../Box/Box.js');
const utils = require('../themes/utils.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const SelectTrigger = React__namespace.forwardRef(({ onClear, clearLabel = 'Clear', startIcon, disabled, hasError, size = 'M', children, ...restProps }, ref) => {
    const triggerRef = React__namespace.useRef(null);
    const handleClearClick = (e) => {
        if (onClear && !disabled) {
            onClear(e);
            triggerRef.current.focus();
        }
    };
    const composedRefs = useComposeRefs.useComposedRefs(triggerRef, ref);
    return (jsxRuntime.jsx(uiPrimitives.Select.Trigger, { asChild: true, children: jsxRuntime.jsxs(StyledTrigger, { "aria-disabled": disabled, "$hasError": hasError, "$size": size, ref: composedRefs, alignItems: "center", justifyContent: "space-between", position: "relative", overflow: "hidden", hasRadius: true, background: disabled ? 'neutral150' : 'neutral0', paddingLeft: 3, paddingRight: 3, paddingTop: 1, paddingBottom: 1, gap: 4, cursor: "default", width: "100%", ...restProps, children: [jsxRuntime.jsxs(Flex.Flex, { flex: "1", as: "span", gap: 3, children: [startIcon && (jsxRuntime.jsx(Box.Box, { as: "span", "aria-hidden": true, children: startIcon })), children] }), jsxRuntime.jsxs(Flex.Flex, { as: "span", gap: 3, children: [onClear ? (jsxRuntime.jsx(IconBox, { as: "button", hasRadius: true, background: "transparent", role: "button", tabIndex: 0, onClick: handleClearClick, "aria-disabled": disabled, "aria-label": clearLabel, title: clearLabel, cursor: "pointer", children: jsxRuntime.jsx(icons.Cross, {}) })) : null, jsxRuntime.jsx(DownIcon, { children: jsxRuntime.jsx(icons.CarretDown, {}) })] })] }) }));
});
const IconBox = styled__default.default(Box.Box) `
  border: none;

  svg {
    height: ${11 / 16}rem;
    width: ${11 / 16}rem;
  }

  svg path {
    fill: ${({ theme }) => theme.colors.neutral600};
  }
`;
const StyledTrigger = styled__default.default(Flex.Flex) `
  border: 1px solid ${({ theme, $hasError }) => ($hasError ? theme.colors.danger600 : theme.colors.neutral200)};
  min-height: ${({ theme, $size }) => utils.getThemeSize('input')({ theme, size: $size })};

  &[aria-disabled='true'] {
    color: ${(props) => props.theme.colors.neutral600};
  }

  /* Required to ensure the below inputFocusStyles are adhered too */
  &:focus-visible {
    outline: none;
  }

  ${({ theme, $hasError }) => utils.inputFocusStyle()({ theme, hasError: $hasError })};
`;
const DownIcon = styled__default.default(uiPrimitives.Select.Icon) `
  & > svg {
    width: ${6 / 16}rem;

    & > path {
      fill: ${({ theme }) => theme.colors.neutral600};
    }
  }
`;
const SelectValue = React__namespace.forwardRef(({ children, placeholder, ...restProps }, ref) => (jsxRuntime.jsx(ValueType, { ref: ref, ellipsis: true, ...restProps, children: jsxRuntime.jsx(StyledValue, { placeholder: placeholder, children: children }) })));
const ValueType = styled__default.default(Typography.Typography) `
  flex: 1;
`;
const StyledValue = styled__default.default(uiPrimitives.Select.Value) `
  display: flex;
  gap: ${({ theme }) => theme.spaces[1]};
  flex-wrap: wrap;
`;
/* -------------------------------------------------------------------------------------------------
 * SelectContent
 * -----------------------------------------------------------------------------------------------*/
const SelectContent = styled__default.default(uiPrimitives.Select.Content) `
  background: ${({ theme }) => theme.colors.neutral0};
  box-shadow: ${({ theme }) => theme.shadows.filterShadow};
  border: 1px solid ${({ theme }) => theme.colors.neutral150};
  border-radius: ${({ theme }) => theme.borderRadius};
  min-width: var(--radix-select-trigger-width);
  /* This is from the design-system figma file. */
  max-height: 15rem;
  z-index: ${({ theme }) => theme.zIndices[1]};
`;
/* -------------------------------------------------------------------------------------------------
 * SelectViewport
 * -----------------------------------------------------------------------------------------------*/
const SelectViewport = styled__default.default(uiPrimitives.Select.Viewport) `
  padding: ${({ theme }) => theme.spaces[1]};
`;
const SelectItem = React__namespace.forwardRef((props, ref) => (jsxRuntime.jsx(StyledSelectItem, { ref: ref, ...props })));
const itemStyles = styled.css `
  width: 100%;
  border: none;
  text-align: left;
  outline-offset: -3px;
  border-radius: ${(props) => props.theme.borderRadius};
  padding: ${(props) => `${props.theme.spaces[2]} ${props.theme.spaces[4]}`};
  padding-left: ${({ theme }) => theme.spaces[4]};
  background-color: ${({ theme }) => theme.colors.neutral0};
  display: flex;
  align-items: center;
  gap: ${({ theme }) => theme.spaces[2]};
  white-space: nowrap;
  user-select: none;

  &:focus-visible {
    outline: none;
    background-color: ${({ theme }) => theme.colors.primary100};
  }
`;
const StyledSelectItem = styled__default.default(uiPrimitives.Select.Item) `
  ${itemStyles}

  &:hover {
    background-color: ${({ theme }) => theme.colors.primary100};
  }

  &[data-state='checked'] {
    ${Typography.Typography} {
      font-weight: bold;
      color: ${({ theme }) => theme.colors.primary600};
    }
  }
`;
const Root = uiPrimitives.Select.Root;
const Trigger = SelectTrigger;
const Value = SelectValue;
const Portal = uiPrimitives.Select.Portal;
const Content = SelectContent;
const Viewport = SelectViewport;
const Item = SelectItem;
const ItemIndicator = uiPrimitives.Select.ItemIndicator;
const ItemText = uiPrimitives.Select.ItemText;
const Group = uiPrimitives.Select.Group;

exports.Content = Content;
exports.Group = Group;
exports.Item = Item;
exports.ItemIndicator = ItemIndicator;
exports.ItemText = ItemText;
exports.Portal = Portal;
exports.Root = Root;
exports.Trigger = Trigger;
exports.Value = Value;
exports.Viewport = Viewport;
