import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { MultiSelect } from './MultiSelect.mjs';
import { SingleSelect } from './SingleSelect.mjs';

const SelectContext = React.createContext({ multi: false });
const useSelectContext = () => React.useContext(SelectContext);
/**
 * @preserve
 * @deprecated You should import the specific type of select you want to render
 *
 * e.g. `import { MultiSelect } from '@strapi/design-system';`
 */
const Select = (props) => {
    const contextValue = React.useMemo(() => ({ multi: Boolean(props.multi || props.withTags) }), [props.multi, props.withTags]);
    return (jsx(SelectContext.Provider, { value: contextValue, children: props.multi || props.withTags ? jsx(MultiSelect, { ...props }) : jsx(SingleSelect, { ...props }) }));
};

export { Select, useSelectContext };
