import { jsx, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import { Cross } from '@strapi/icons';
import styled, { css } from 'styled-components';
import { Root, Trigger, Value, Portal, Content, Viewport, Item, ItemIndicator, ItemText, Group } from './SelectParts.mjs';
import checkmarkIcon from '../BaseCheckbox/assets/checkmark.svg.mjs';
import { stripReactIdOfColon } from '../helpers/strings.mjs';
import { useComposedRefs } from '../hooks/useComposeRefs.mjs';
import { useId } from '../hooks/useId.mjs';
import { useIntersection } from '../hooks/useIntersection.mjs';
import { Tag } from '../Tag/Tag.mjs';
import { Field } from '../Field/Field.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { Box } from '../Box/Box.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';
import { Typography } from '../Typography/Typography.mjs';

const MultiSelect = React.forwardRef(({ 'aria-label': ariaLabel, children, clearLabel = 'Clear', customizeContent, disabled, error, hint, id, label, labelAction, onChange, onClear, onCloseAutoFocus, onReachEnd, placeholder, required, selectButtonTitle: _deprecatedSelectButtonTitle, startIcon, size = 'M', value: passedValue, withTags, ...restProps }, forwardedRef) => {
    /**
     * Used for the intersection observer
     */
    const viewportRef = React.useRef(null);
    /**
     * These values are drawn out from the internals of the Radix component
     * We can then use them to react to visual changes for the component
     */
    const [internalValue, setInternalValue] = React.useState();
    const [internalIsOpen, setInternalIsOpen] = React.useState(false);
    const generatedId = useId(id);
    const hintId = `${generatedId}-hint`;
    const errorId = `${generatedId}-error`;
    const handleValueChange = (value) => {
        /**
         * If it's being externally managed then we shouldn't
         * both setting our copy of the internal value.
         */
        if (onChange) {
            onChange(value);
        }
        else {
            setInternalValue(value);
        }
    };
    const handleTagClick = (value) => () => {
        const newValue = Array.isArray(passedValue)
            ? passedValue.filter((val) => val !== value)
            : (internalValue ?? []).filter((val) => val !== value);
        if (onChange) {
            onChange(newValue);
        }
        else {
            setInternalValue(newValue);
        }
    };
    const handleOpenChange = (open) => {
        setInternalIsOpen(open);
    };
    /**
     * Because the trigger needs to be a `div` to allow the clear
     * button & tags to be clickable, we need to manually focus it.
     */
    const triggerRef = React.useRef(null);
    const handleFieldLabelClick = () => {
        triggerRef.current.focus();
    };
    const generatedIntersectionId = useId();
    const intersectionId = `intersection-${stripReactIdOfColon(generatedIntersectionId)}`;
    const handleReachEnd = (entry) => {
        if (onReachEnd) {
            onReachEnd(entry);
        }
    };
    useIntersection(viewportRef, handleReachEnd, {
        selectorToWatch: `#${intersectionId}`,
        /**
         * We need to know when the select is open because only then will viewportRef
         * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
         */
        skipWhen: !internalIsOpen,
    });
    const value = typeof passedValue !== 'undefined' && passedValue !== null ? passedValue : internalValue;
    const renderTags = (arg) => {
        if (arg && typeof arg === 'object' && arg.value) {
            return (jsx(Tag, { tabIndex: -1, disabled: disabled, icon: jsx(Cross, {}), onClick: handleTagClick(arg.value), children: arg.textValue }, arg.value));
        }
        return null;
    };
    const composedTriggerRefs = useComposedRefs(triggerRef, forwardedRef);
    return (jsx(Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label ? (jsx(FieldLabel, { onClick: handleFieldLabelClick, action: labelAction, children: label })) : null, jsxs(Root, { onOpenChange: handleOpenChange, disabled: disabled, required: required, onValueChange: handleValueChange, value: value, ...restProps, multi: true, children: [jsx(Trigger, { ref: composedTriggerRefs, "aria-label": label ?? ariaLabel, "aria-describedby": `${hintId} ${errorId}`, id: generatedId, startIcon: startIcon, size: size, hasError: Boolean(error), disabled: disabled, clearLabel: clearLabel, onClear: value?.length ? onClear : undefined, paddingLeft: withTags && value?.length ? 1 : 3, children: jsx(Value, { placeholder: placeholder, textColor: value?.length ? 'neutral800' : 'neutral600', children: value?.length
                                    ? withTags
                                        ? renderTags
                                        : customizeContent
                                            ? customizeContent(value)
                                            : undefined
                                    : undefined }) }), jsx(Portal, { children: jsx(Content, { position: "popper", sideOffset: 4, onCloseAutoFocus: onCloseAutoFocus, children: jsxs(Viewport, { ref: viewportRef, children: [children, jsx(Box, { id: intersectionId, width: "100%", height: "1px" })] }) }) })] }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});
const MultiSelectOption = React.forwardRef(({ value, children, startIcon, ...restProps }, ref) => {
    return (jsxs(Item, { ref: ref, value: value.toString(), ...restProps, children: [startIcon && (jsx(Box, { as: "span", "aria-hidden": true, children: startIcon })), jsx(ItemIndicator, { children: ({ isSelected, isIntermediate }) => (jsx(CheckMark, { hasRadius: true, overflow: "hidden", position: "relative", "$indeterminate": isIntermediate, "$selected": isSelected, zIndex: 1, height: "18px", width: "18px" })) }), jsx(Typography, { textColor: "neutral800", children: jsx(ItemText, { children: children }) })] }));
});
const CheckMark = styled(Box) `
  border: 1px solid
    ${({ theme, $selected, $indeterminate }) => $selected || $indeterminate ? theme.colors.primary600 : theme.colors.neutral300};
  background-color: ${({ theme, $selected, $indeterminate }) => $selected || $indeterminate ? theme.colors.primary600 : theme.colors.neutral0};

  ${({ theme, $indeterminate }) => $indeterminate &&
    css `
      &::after {
        content: '';
        display: block;
        position: relative;
        color: white;
        height: 2px;
        width: 10px;
        background-color: ${theme.colors.neutral0};
        left: 50%;
        top: 50%;
        transform: translateX(-50%) translateY(-50%);
      }
    `}

  ${({ $selected }) => $selected &&
    css `
      &::after {
        content: '';
        background: ${() => `url("${checkmarkIcon}") no-repeat no-repeat center center`};
        width: 100%;
        height: 100%;
        position: absolute;
      }
    `}
`;
const MultiSelectGroup = React.forwardRef(({ children, label, startIcon, values = [], ...restProps }, ref) => {
    return (jsxs(Group, { ref: ref, children: [jsxs(Item, { value: values, ...restProps, children: [startIcon && (jsx(Box, { as: "span", "aria-hidden": true, children: startIcon })), jsx(ItemIndicator, { children: ({ isSelected, isIntermediate }) => (jsx(CheckMark, { hasRadius: true, overflow: "hidden", position: "relative", "$indeterminate": isIntermediate, "$selected": isSelected, zIndex: 1, height: "18px", width: "18px" })) }), jsx(Typography, { textColor: "neutral800", children: label })] }), children] }));
});

export { MultiSelect, MultiSelectGroup, MultiSelectOption };
