'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const SelectParts = require('./SelectParts.js');
const checkmark = require('../BaseCheckbox/assets/checkmark.svg.js');
const strings = require('../helpers/strings.js');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const useId = require('../hooks/useId.js');
const useIntersection = require('../hooks/useIntersection.js');
const Tag = require('../Tag/Tag.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const FieldLabel = require('../Field/FieldLabel.js');
const Box = require('../Box/Box.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const MultiSelect = React__namespace.forwardRef(({ 'aria-label': ariaLabel, children, clearLabel = 'Clear', customizeContent, disabled, error, hint, id, label, labelAction, onChange, onClear, onCloseAutoFocus, onReachEnd, placeholder, required, selectButtonTitle: _deprecatedSelectButtonTitle, startIcon, size = 'M', value: passedValue, withTags, ...restProps }, forwardedRef) => {
    /**
     * Used for the intersection observer
     */
    const viewportRef = React__namespace.useRef(null);
    /**
     * These values are drawn out from the internals of the Radix component
     * We can then use them to react to visual changes for the component
     */
    const [internalValue, setInternalValue] = React__namespace.useState();
    const [internalIsOpen, setInternalIsOpen] = React__namespace.useState(false);
    const generatedId = useId.useId(id);
    const hintId = `${generatedId}-hint`;
    const errorId = `${generatedId}-error`;
    const handleValueChange = (value) => {
        /**
         * If it's being externally managed then we shouldn't
         * both setting our copy of the internal value.
         */
        if (onChange) {
            onChange(value);
        }
        else {
            setInternalValue(value);
        }
    };
    const handleTagClick = (value) => () => {
        const newValue = Array.isArray(passedValue)
            ? passedValue.filter((val) => val !== value)
            : (internalValue ?? []).filter((val) => val !== value);
        if (onChange) {
            onChange(newValue);
        }
        else {
            setInternalValue(newValue);
        }
    };
    const handleOpenChange = (open) => {
        setInternalIsOpen(open);
    };
    /**
     * Because the trigger needs to be a `div` to allow the clear
     * button & tags to be clickable, we need to manually focus it.
     */
    const triggerRef = React__namespace.useRef(null);
    const handleFieldLabelClick = () => {
        triggerRef.current.focus();
    };
    const generatedIntersectionId = useId.useId();
    const intersectionId = `intersection-${strings.stripReactIdOfColon(generatedIntersectionId)}`;
    const handleReachEnd = (entry) => {
        if (onReachEnd) {
            onReachEnd(entry);
        }
    };
    useIntersection.useIntersection(viewportRef, handleReachEnd, {
        selectorToWatch: `#${intersectionId}`,
        /**
         * We need to know when the select is open because only then will viewportRef
         * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
         */
        skipWhen: !internalIsOpen,
    });
    const value = typeof passedValue !== 'undefined' && passedValue !== null ? passedValue : internalValue;
    const renderTags = (arg) => {
        if (arg && typeof arg === 'object' && arg.value) {
            return (jsxRuntime.jsx(Tag.Tag, { tabIndex: -1, disabled: disabled, icon: jsxRuntime.jsx(icons.Cross, {}), onClick: handleTagClick(arg.value), children: arg.textValue }, arg.value));
        }
        return null;
    };
    const composedTriggerRefs = useComposeRefs.useComposedRefs(triggerRef, forwardedRef);
    return (jsxRuntime.jsx(Field.Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label ? (jsxRuntime.jsx(FieldLabel.FieldLabel, { onClick: handleFieldLabelClick, action: labelAction, children: label })) : null, jsxRuntime.jsxs(SelectParts.Root, { onOpenChange: handleOpenChange, disabled: disabled, required: required, onValueChange: handleValueChange, value: value, ...restProps, multi: true, children: [jsxRuntime.jsx(SelectParts.Trigger, { ref: composedTriggerRefs, "aria-label": label ?? ariaLabel, "aria-describedby": `${hintId} ${errorId}`, id: generatedId, startIcon: startIcon, size: size, hasError: Boolean(error), disabled: disabled, clearLabel: clearLabel, onClear: value?.length ? onClear : undefined, paddingLeft: withTags && value?.length ? 1 : 3, children: jsxRuntime.jsx(SelectParts.Value, { placeholder: placeholder, textColor: value?.length ? 'neutral800' : 'neutral600', children: value?.length
                                    ? withTags
                                        ? renderTags
                                        : customizeContent
                                            ? customizeContent(value)
                                            : undefined
                                    : undefined }) }), jsxRuntime.jsx(SelectParts.Portal, { children: jsxRuntime.jsx(SelectParts.Content, { position: "popper", sideOffset: 4, onCloseAutoFocus: onCloseAutoFocus, children: jsxRuntime.jsxs(SelectParts.Viewport, { ref: viewportRef, children: [children, jsxRuntime.jsx(Box.Box, { id: intersectionId, width: "100%", height: "1px" })] }) }) })] }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});
const MultiSelectOption = React__namespace.forwardRef(({ value, children, startIcon, ...restProps }, ref) => {
    return (jsxRuntime.jsxs(SelectParts.Item, { ref: ref, value: value.toString(), ...restProps, children: [startIcon && (jsxRuntime.jsx(Box.Box, { as: "span", "aria-hidden": true, children: startIcon })), jsxRuntime.jsx(SelectParts.ItemIndicator, { children: ({ isSelected, isIntermediate }) => (jsxRuntime.jsx(CheckMark, { hasRadius: true, overflow: "hidden", position: "relative", "$indeterminate": isIntermediate, "$selected": isSelected, zIndex: 1, height: "18px", width: "18px" })) }), jsxRuntime.jsx(Typography.Typography, { textColor: "neutral800", children: jsxRuntime.jsx(SelectParts.ItemText, { children: children }) })] }));
});
const CheckMark = styled__default.default(Box.Box) `
  border: 1px solid
    ${({ theme, $selected, $indeterminate }) => $selected || $indeterminate ? theme.colors.primary600 : theme.colors.neutral300};
  background-color: ${({ theme, $selected, $indeterminate }) => $selected || $indeterminate ? theme.colors.primary600 : theme.colors.neutral0};

  ${({ theme, $indeterminate }) => $indeterminate &&
    styled.css `
      &::after {
        content: '';
        display: block;
        position: relative;
        color: white;
        height: 2px;
        width: 10px;
        background-color: ${theme.colors.neutral0};
        left: 50%;
        top: 50%;
        transform: translateX(-50%) translateY(-50%);
      }
    `}

  ${({ $selected }) => $selected &&
    styled.css `
      &::after {
        content: '';
        background: ${() => `url("${checkmark}") no-repeat no-repeat center center`};
        width: 100%;
        height: 100%;
        position: absolute;
      }
    `}
`;
const MultiSelectGroup = React__namespace.forwardRef(({ children, label, startIcon, values = [], ...restProps }, ref) => {
    return (jsxRuntime.jsxs(SelectParts.Group, { ref: ref, children: [jsxRuntime.jsxs(SelectParts.Item, { value: values, ...restProps, children: [startIcon && (jsxRuntime.jsx(Box.Box, { as: "span", "aria-hidden": true, children: startIcon })), jsxRuntime.jsx(SelectParts.ItemIndicator, { children: ({ isSelected, isIntermediate }) => (jsxRuntime.jsx(CheckMark, { hasRadius: true, overflow: "hidden", position: "relative", "$indeterminate": isIntermediate, "$selected": isSelected, zIndex: 1, height: "18px", width: "18px" })) }), jsxRuntime.jsx(Typography.Typography, { textColor: "neutral800", children: label })] }), children] }));
});

exports.MultiSelect = MultiSelect;
exports.MultiSelectGroup = MultiSelectGroup;
exports.MultiSelectOption = MultiSelectOption;
