import { jsx, jsxs } from 'react/jsx-runtime';
import { forwardRef, useRef } from 'react';
import { Cross, Search } from '@strapi/icons';
import styled from 'styled-components';
import { composeRefs } from '../hooks/useComposeRefs.mjs';
import { inputFocusStyle } from '../themes/utils.mjs';
import { InputWrapper, FieldInput } from '../Field/FieldInput.mjs';
import { FieldAction } from '../Field/FieldAction.mjs';
import { Field } from '../Field/Field.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';

const CloseIcon = styled(Cross) `
  font-size: 0.5rem;
  path {
    fill: ${({ theme }) => theme.colors.neutral400};
  }
`;
const SearchIcon = styled(Search) `
  font-size: 0.8rem;
  path {
    fill: ${({ theme }) => theme.colors.neutral800};
  }
`;
const SearchbarWrapper = styled.div `
  border-radius: ${({ theme }) => theme.borderRadius};
  box-shadow: ${({ theme }) => theme.shadows.filterShadow};

  &:focus-within {
    ${SearchIcon} {
      path {
        fill: ${({ theme }) => theme.colors.primary600};
      }
    }
  }

  ${InputWrapper} {
    border: 1px solid transparent;
  }

  ${inputFocusStyle(InputWrapper)}
`;
const Searchbar = forwardRef(({ name, size = 'M', children, value = '', onClear, clearLabel, ...props }, ref) => {
    const inputRef = useRef(null);
    const isCompleting = value.length > 0;
    const handleClear = (e) => {
        onClear(e);
        inputRef.current.focus();
    };
    const actualRef = composeRefs(ref, inputRef);
    return (jsx(SearchbarWrapper, { children: jsxs(Field, { name: name, children: [jsx(VisuallyHidden, { children: jsx(FieldLabel, { children: children }) }), jsx(FieldInput, { ref: actualRef, value: value, startAction: jsx(SearchIcon, { "aria-hidden": true }), size: size, endAction: isCompleting ? (jsx(FieldAction, { label: clearLabel, onClick: handleClear, children: jsx(CloseIcon, {}) })) : undefined, ...props })] }) }));
});

export { Searchbar };
