import { jsx } from 'react/jsx-runtime';
import { Children, isValidElement, cloneElement } from 'react';
import { Box } from '../Box/Box.mjs';

const RawTr = ({ children, ...props }) => {
    const childrenClone = Children.toArray(children).map((child, index) => {
        if (isValidElement(child)) {
            return cloneElement(child, {
                'aria-colindex': index + 1,
                coords: { col: index + 1, row: props['aria-rowindex'] },
            });
        }
        return child;
    });
    return (jsx(Box, { as: "tr", ...props, children: childrenClone }));
};

export { RawTr };
