import { jsx } from 'react/jsx-runtime';
import { Children, isValidElement, cloneElement } from 'react';

const RawThead = ({ children, ...props }) => {
    /**
     * aria-rowindex is 1-based: we have to start from 1
     */
    const childrenClone = Children.toArray(children).map((child) => {
        if (isValidElement(child)) {
            return cloneElement(child, { 'aria-rowindex': 1 });
        }
        return child;
    });
    return jsx("thead", { ...props, children: childrenClone });
};

export { RawThead };
