'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');

const RawTableContext = React.createContext({
    rowIndex: 0,
    colIndex: 0,
    setTableValues() {
        throw new Error('setTableValues must be initialized via the RawTableContext.Provider');
    },
});
const useTable = () => React.useContext(RawTableContext);

exports.RawTableContext = RawTableContext;
exports.useTable = useTable;
