'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const ProgressbarBase = styled__default.default(Box.Box) `
  &:before {
    background-color: ${({ theme }) => theme.colors.neutral0};
    border-radius: ${({ theme }) => theme.borderRadius};
    bottom: 0;
    content: '';
    position: absolute;
    top: 0;
    width: ${({ value }) => `${value}%`};
  }
`;
const ProgressBar = ({ min = 0, max = 100, value = 0, children, size = 'M', ...props }) => {
    return (jsxRuntime.jsx(ProgressbarBase, { background: "neutral600", hasRadius: true, "aria-label": children, "aria-valuemax": max, "aria-valuemin": min, "aria-valuenow": value, height: size === 'S' ? 1 : 2, position: "relative", role: "progressbar", value: value, width: size === 'S' ? '78px' : '102px', ...props }));
};

exports.ProgressBar = ProgressBar;
