'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const reactDom = require('@floating-ui/react-dom');
const reactFocusScope = require('@radix-ui/react-focus-scope');
const uiPrimitives = require('@strapi/ui-primitives');
const ariaHidden = require('aria-hidden');
const reactRemoveScroll = require('react-remove-scroll');
const styled = require('styled-components');
const index = require('../DismissibleLayer/index.js');
const strings = require('../helpers/strings.js');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const useId = require('../hooks/useId.js');
const useIntersection = require('../hooks/useIntersection.js');
const Box = require('../Box/Box.js');
const Portal = require('../Portal/Portal.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const POPOVER_PLACEMENTS = [
    'top',
    'top-start',
    'top-end',
    'right',
    'right-start',
    'right-end',
    'bottom',
    'bottom-start',
    'bottom-end',
    'left',
    'left-start',
    'left-end',
];
const PopoverWrapper = styled__default.default(Box.Box) `
  box-shadow: ${({ theme }) => theme.shadows.filterShadow};
  z-index: ${({ theme }) => theme.zIndices[0]};
  border: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const Content = React__namespace.forwardRef(({ source, children, spacing = 0, fullWidth = false, placement = 'bottom-start', centered = false, onEscapeKeyDown, onPointerDownOutside, onDismiss, onFocusOutside, ...props }, forwardedRef) => {
    const [content, setContent] = React__namespace.useState(null);
    const [width, setWidth] = React__namespace.useState(undefined);
    const isRightClickOutsideRef = React__namespace.useRef(false);
    const { x, y, refs, strategy } = reactDom.useFloating({
        strategy: 'fixed',
        placement: centered ? 'bottom' : placement,
        middleware: [
            reactDom.offset({
                mainAxis: spacing,
            }),
            reactDom.shift(),
            reactDom.flip(),
        ],
        elements: {
            reference: source.current,
        },
        whileElementsMounted: reactDom.autoUpdate,
    });
    React__namespace.useLayoutEffect(() => {
        if (fullWidth) {
            setWidth(source.current.offsetWidth);
        }
    }, [fullWidth, source]);
    // aria-hide everything except the content (better supported equivalent to setting aria-modal)
    React__namespace.useEffect(() => {
        if (content)
            return ariaHidden.hideOthers(content);
    }, [content]);
    const handleDismiss = uiPrimitives.useCallbackRef(onDismiss);
    React__namespace.useEffect(() => {
        const close = () => {
            handleDismiss();
        };
        window.addEventListener('blur', close);
        window.addEventListener('resize', close);
        return () => {
            window.removeEventListener('blur', close);
            window.removeEventListener('resize', close);
        };
    }, [handleDismiss]);
    const composedRefs = useComposeRefs.useComposedRefs(forwardedRef, (node) => setContent(node), refs.setFloating);
    return (jsxRuntime.jsx(reactRemoveScroll.RemoveScroll, { allowPinchZoom: true, children: jsxRuntime.jsx(reactFocusScope.FocusScope, { asChild: true, loop: true, 
            // we make sure we're not trapping once it's been closed
            // (closed !== unmounted when animating out)
            trapped: true, onUnmountAutoFocus: (event) => {
                event.preventDefault();
                if (!isRightClickOutsideRef.current)
                    source.current?.focus({ preventScroll: true });
            }, children: jsxRuntime.jsx(index.DismissibleLayer, { asChild: true, onEscapeKeyDown: onEscapeKeyDown, onPointerDownOutside: uiPrimitives.composeEventHandlers(onPointerDownOutside, (event) => {
                    const originalEvent = event.detail.originalEvent;
                    const ctrlLeftClick = originalEvent.button === 0 && originalEvent.ctrlKey === true;
                    const isRightClick = originalEvent.button === 2 || ctrlLeftClick;
                    isRightClickOutsideRef.current = isRightClick;
                }, { checkForDefaultPrevented: false }), 
                // When focus is trapped, a `focusout` event may still happen.
                // We make sure we don't trigger our `onDismiss` in such case.
                onFocusOutside: uiPrimitives.composeEventHandlers(onFocusOutside, (event) => event.preventDefault(), {
                    checkForDefaultPrevented: false,
                }), onDismiss: onDismiss, children: jsxRuntime.jsx(PopoverWrapper, { ref: composedRefs, style: {
                        left: x,
                        top: y,
                        position: strategy,
                        width: width || undefined,
                    }, hasRadius: true, background: "neutral0", padding: 1, ...props, children: children }) }) }) }));
});
const Scrolling = ({ children, intersectionId, onReachEnd, ...props }) => {
    const popoverRef = React__namespace.useRef(null);
    const generatedIntersectionId = useId.useId();
    useIntersection.useIntersection(popoverRef, onReachEnd ?? (() => { }), {
        selectorToWatch: `#${strings.stripReactIdOfColon(generatedIntersectionId)}`,
        skipWhen: !intersectionId || !onReachEnd,
    });
    return (jsxRuntime.jsxs(PopoverScrollable, { ref: popoverRef, ...props, children: [children, intersectionId && onReachEnd && (jsxRuntime.jsx(Box.Box, { id: strings.stripReactIdOfColon(generatedIntersectionId), width: "100%", height: "1px" }))] }));
};
const PopoverScrollable = styled__default.default(Box.Box) `
  // 16 is base base size, 3 is the factor to get closer to 40px and 5 is the number of elements visible in the list
  max-height: ${3 * 5}rem;
  overflow-y: auto;
  overflow-x: hidden;

  &::-webkit-scrollbar {
    -webkit-appearance: none;
    width: 4px;
  }

  &::-webkit-scrollbar-track {
    background: ${({ theme }) => theme.colors.neutral0};
  }

  &::-webkit-scrollbar-thumb {
    background: ${({ theme }) => theme.colors.neutral150};
    border-radius: ${({ theme }) => theme.borderRadius};
    margin-right: 10px;
  }
`;
const Popover = ({ children, source, spacing, fullWidth, placement, centered, onEscapeKeyDown, onPointerDownOutside, onDismiss, ...restProps }) => {
    return (jsxRuntime.jsx(Portal.Portal, { children: jsxRuntime.jsx(Content, { source: source, spacing: spacing, fullWidth: fullWidth, placement: placement, centered: centered, onEscapeKeyDown: onEscapeKeyDown, onPointerDownOutside: onPointerDownOutside, onDismiss: onDismiss, children: jsxRuntime.jsx(Scrolling, { ...restProps, children: children }) }) }));
};

exports.Content = Content;
exports.POPOVER_PLACEMENTS = POPOVER_PLACEMENTS;
exports.Popover = Popover;
exports.Scrolling = Scrolling;
