'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const reactRouterDom = require('react-router-dom');
const styled = require('styled-components');
const PaginationContext = require('./PaginationContext.js');
const utils = require('../themes/utils.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const Typography = require('../Typography/Typography.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const transientProps = {
    active: true,
};
const LinkWrapper = styled__default.default(reactRouterDom.NavLink).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  padding: ${({ theme }) => theme.spaces[3]};
  border-radius: ${({ theme }) => theme.borderRadius};
  box-shadow: ${({ active, theme }) => (active ? theme.shadows.filterShadow : undefined)};
  text-decoration: none;
  display: flex;

  ${utils.buttonFocusStyle}
`;
const PageLinkWrapper = styled__default.default(LinkWrapper) `
  color: ${({ theme, active }) => (active ? theme.colors.primary700 : theme.colors.neutral800)};
  background: ${({ theme, active }) => (active ? theme.colors.neutral0 : undefined)};

  &:hover {
    box-shadow: ${({ theme }) => theme.shadows.filterShadow};
  }
`;
const ActionLinkWrapper = styled__default.default(LinkWrapper) `
  font-size: ${11 / 16}rem;

  svg path {
    fill: ${(p) => (p['aria-disabled'] ? p.theme.colors.neutral300 : p.theme.colors.neutral600)};
  }

  &:focus,
  &:hover {
    svg path {
      fill: ${(p) => (p['aria-disabled'] ? p.theme.colors.neutral300 : p.theme.colors.neutral700)};
    }
  }

  ${(p) => p['aria-disabled']
    ? `
  pointer-events: none;
    `
    : undefined}
`;
const PreviousLink = ({ children, to, ...props }) => {
    const { activePage } = PaginationContext.usePagination();
    const disabled = activePage === 1;
    return (jsxRuntime.jsxs(ActionLinkWrapper, { to: disabled ? '#' : to, "aria-disabled": disabled, tabIndex: disabled ? -1 : undefined, ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(icons.ChevronLeft, { "aria-hidden": true })] }));
};
PreviousLink.displayName = 'PreviousLink';
const NextLink = ({ children, to, ...props }) => {
    const { activePage, pageCount } = PaginationContext.usePagination();
    const disabled = activePage === pageCount;
    return (jsxRuntime.jsxs(ActionLinkWrapper, { to: disabled ? '#' : to, "aria-disabled": disabled, tabIndex: disabled ? -1 : undefined, ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(icons.ChevronRight, { "aria-hidden": true })] }));
};
NextLink.displayName = 'NextLink';
const PageLink = ({ number, children, ...props }) => {
    const { activePage } = PaginationContext.usePagination();
    const isActive = activePage === number;
    return (jsxRuntime.jsxs(PageLinkWrapper, { ...props, active: isActive, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(Typography.Typography, { "aria-hidden": true, fontWeight: isActive ? 'bold' : undefined, lineHeight: "revert", variant: "pi", children: number })] }));
};
PageLink.displayName = 'PageLink';
const Dots = ({ children, ...props }) => (jsxRuntime.jsxs(Box.Box, { ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(Typography.Typography, { "aria-hidden": true, lineHeight: "revert", textColor: "neutral800", variant: "pi", children: "\u2026" })] }));

exports.Dots = Dots;
exports.NextLink = NextLink;
exports.PageLink = PageLink;
exports.PreviousLink = PreviousLink;
