'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const number = require('@internationalized/number');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const DesignSystemProvider = require('../DesignSystemProvider.js');
const keyboardKeys = require('../helpers/keyboardKeys.js');
const useControllableState = require('../hooks/useControllableState.js');
const useId = require('../hooks/useId.js');
const FieldInput = require('../Field/FieldInput.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const FieldLabel = require('../Field/FieldLabel.js');
const Icon = require('../Icon/Icon.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const ArrowButton = styled__default.default.button `
  display: flex;
  height: 1rem;
  align-items: ${({ reverse }) => (reverse ? 'flex-end' : 'flex-start')};
  transform: translateY(${({ reverse }) => (reverse ? `-2px` : `2px`)});
  cursor: ${({ disabled }) => (disabled ? 'not-allowed' : undefined)};
  svg {
    display: block;
    height: ${4 / 16}rem;
    transform: ${({ reverse }) => (reverse ? 'rotateX(180deg)' : undefined)};
  }
`;
const INITIAL_VALUE = '';
const NumberInput = React__default.default.forwardRef(({ size = 'M', startAction, name, hint, error, label, labelAction, locale: defaultLocale, id, onValueChange, value, step = 1, required = false, disabled = false, ...props }, ref) => {
    const generatedId = useId.useId(id);
    const designContext = DesignSystemProvider.useDesignSystem('NumberInput');
    const locale = defaultLocale || designContext.locale;
    const numberParserRef = React.useRef(new number.NumberParser(locale, { style: 'decimal' }));
    const numberFormaterRef = React.useRef(new number.NumberFormatter(locale, { maximumFractionDigits: 20 }));
    const [inputValue, setInputValue] = useControllableState.useControllableState({
        prop(currentInputValue) {
            const stringifiedValue = String(value);
            /**
             * This basically accounts for when someone wants to:
             * 1. clear the input
             * 2. use a minus value
             * 3. use a decimal value
             *
             * And always give it a string
             */
            return isNaN(Number(stringifiedValue)) || (stringifiedValue !== currentInputValue && currentInputValue !== '')
                ? currentInputValue
                : numberFormaterRef.current.format(Number(value));
        },
        defaultProp: INITIAL_VALUE,
        onChange(value) {
            /**
             * always return a
             */
            const parsedValue = numberParserRef.current.parse(value ?? '');
            onValueChange(isNaN(parsedValue) ? undefined : parsedValue);
        },
    });
    /**
     * Value will either be a number or a string,
     * if the former then it'll be converted to a string.
     */
    const formatNumberAndSetInput = (value) => {
        setInputValue(String(value));
    };
    const handelInputChange = ({ target: { value } }) => {
        if (numberParserRef.current.isValidPartialNumber(value)) {
            formatNumberAndSetInput(value);
        }
    };
    const increment = () => {
        if (!inputValue) {
            formatNumberAndSetInput(step);
            return;
        }
        const parsedValue = numberParserRef.current.parse(inputValue);
        const newValue = isNaN(parsedValue) ? step : parsedValue + step;
        formatNumberAndSetInput(numberFormaterRef.current.format(newValue));
    };
    const decrement = () => {
        if (!inputValue) {
            formatNumberAndSetInput(-step);
            return;
        }
        const parsedValue = numberParserRef.current.parse(inputValue);
        const newValue = isNaN(parsedValue) ? -step : parsedValue - step;
        formatNumberAndSetInput(numberFormaterRef.current.format(newValue));
    };
    const handleKeyDown = (e) => {
        if (disabled)
            return;
        switch (e.key) {
            case keyboardKeys.KeyboardKeys.DOWN: {
                e.preventDefault();
                decrement();
                break;
            }
            case keyboardKeys.KeyboardKeys.UP: {
                e.preventDefault();
                increment();
                break;
            }
        }
    };
    /**
     * Only format on blur as vanity because otherwise it breaks when a user
     * wants to include a minus or decimal value.
     */
    const handleBlur = () => {
        if (inputValue) {
            const parsedValue = numberParserRef.current.parse(inputValue);
            const formattedValue = isNaN(parsedValue) ? '' : numberFormaterRef.current.format(parsedValue);
            formatNumberAndSetInput(formattedValue);
        }
    };
    return (jsxRuntime.jsx(Field.Field, { name: name, hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label && jsxRuntime.jsx(FieldLabel.FieldLabel, { action: labelAction, children: label }), jsxRuntime.jsx(FieldInput.FieldInput, { ref: ref, startAction: startAction, disabled: disabled, type: "text", inputMode: "decimal", onChange: handelInputChange, onKeyDown: handleKeyDown, onBlur: handleBlur, value: inputValue, size: size, endAction: jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [jsxRuntime.jsx(ArrowButton, { disabled: disabled, "aria-hidden": true, reverse: true, onClick: increment, tabIndex: -1, type: "button", "data-testid": "ArrowUp", children: jsxRuntime.jsx(Icon.Icon, { as: icons.CarretDown, color: "neutral500" }) }), jsxRuntime.jsx(ArrowButton, { disabled: disabled, "aria-hidden": true, onClick: decrement, tabIndex: -1, type: "button", "data-testid": "ArrowDown", children: jsxRuntime.jsx(Icon.Icon, { as: icons.CarretDown, color: "neutral500" }) })] }), ...props }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});

exports.NumberInput = NumberInput;
