'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const ModalContext = require('./ModalContext.js');
const index = require('../DismissibleLayer/index.js');
const useLockScroll = require('../hooks/useLockScroll.js');
const Flex = require('../Flex/Flex.js');
const Portal = require('../Portal/Portal.js');
const FocusTrap = require('../FocusTrap/FocusTrap.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const ModalWrapper = styled__default.default(Flex.Flex) `
  background: ${({ theme }) => `${theme.colors.neutral800}1F`};
  inset: 0;
`;
const ModalLayout = ({ onClose, labelledBy, ...props }) => {
    useLockScroll(true);
    return (jsxRuntime.jsx(Portal.Portal, { children: jsxRuntime.jsx(ModalContext.ModalContext.Provider, { value: onClose, children: jsxRuntime.jsx(ModalWrapper, { justifyContent: "center", paddingLeft: 8, paddingRight: 8, position: "fixed", zIndex: 4, children: jsxRuntime.jsx(FocusTrap.FocusTrap, { children: jsxRuntime.jsx(index.DismissibleLayer, { onEscapeKeyDown: onClose, onPointerDownOutside: onClose, children: jsxRuntime.jsx(Box.Box, { "aria-labelledby": labelledBy, "aria-modal": true, onClick: (e) => e.stopPropagation(), background: "neutral0", hasRadius: true, role: "dialog", shadow: "popupShadow", width: `${830 / 16}rem`, ...props }) }) }) }) }) }));
};

exports.ModalLayout = ModalLayout;
