'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const ModalContext = require('./ModalContext.js');
const IconButton = require('../IconButton/IconButton.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const ModalHeaderWrapper = styled__default.default(Box.Box) `
  border-radius: ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius} 0 0;
  border-bottom: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const ModalHeader = ({ children, closeLabel = 'Close the modal' }) => {
    const onClose = ModalContext.useModal();
    return (jsxRuntime.jsx(ModalHeaderWrapper, { paddingTop: 4, paddingBottom: 4, paddingLeft: 5, paddingRight: 5, background: "neutral100", children: jsxRuntime.jsxs(Flex.Flex, { justifyContent: "space-between", children: [children, jsxRuntime.jsx(IconButton.IconButton, { onClick: onClose, "aria-label": closeLabel, icon: jsxRuntime.jsx(icons.Cross, {}) })] }) }));
};

exports.ModalHeader = ModalHeader;
