'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const ModalFooterWrapper = styled__default.default(Box.Box) `
  border-radius: 0 0 ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius};
  border-top: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const ModalFooter = ({ startActions, endActions }) => {
    return (jsxRuntime.jsx(ModalFooterWrapper, { paddingTop: 4, paddingBottom: 4, paddingLeft: 5, paddingRight: 5, background: "neutral100", children: jsxRuntime.jsxs(Flex.Flex, { justifyContent: "space-between", children: [jsxRuntime.jsx(Flex.Flex, { gap: 2, children: startActions }), jsxRuntime.jsx(Flex.Flex, { gap: 2, children: endActions })] }) }));
};

exports.ModalFooter = ModalFooter;
