import { jsxs, jsx } from 'react/jsx-runtime';
import React__default from 'react';
import { useMainNav } from './MainNavContext.mjs';
import { Divider } from '../Divider/Divider.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Box } from '../Box/Box.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { Typography } from '../Typography/Typography.mjs';

const NavSection = ({ label, children, spacing = 2, horizontal = false, ...props }) => {
    const condensed = useMainNav();
    if (condensed) {
        return (jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 2, children: [jsxs(Box, { paddingTop: 1, paddingBottom: 1, background: "neutral0", hasRadius: true, as: "span", children: [jsx(Divider, {}), jsx(VisuallyHidden, { children: jsx("span", { children: label }) })] }), jsx(Flex, { as: "ul", gap: spacing, direction: horizontal ? 'row' : 'column', alignItems: horizontal ? 'center' : 'stretch', ...props, children: React__default.Children.map(children, (child, index) => {
                        // eslint-disable-next-line react/no-array-index-key
                        return jsx("li", { children: child }, index);
                    }) })] }));
    }
    return (jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 2, children: [jsx(Box, { paddingTop: 1, paddingBottom: 1, background: "neutral0", paddingRight: 3, paddingLeft: 3, hasRadius: true, as: "span", children: jsx(Typography, { variant: "sigma", textColor: "neutral600", children: label }) }), jsx(Flex, { as: "ul", gap: spacing, direction: horizontal ? 'row' : 'column', alignItems: horizontal ? 'center' : 'stretch', ...props, children: React__default.Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsx("li", { children: child }, index);
                }) })] }));
};

export { NavSection };
