'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const MainNavContext = require('./MainNavContext.js');
const Icon = require('../Icon/Icon.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const NavCondenseWrapper = styled__default.default.button `
  background: ${({ theme }) => theme.colors.neutral0};
  border: 1px solid ${({ theme }) => theme.colors.neutral150};
  border-radius: ${({ theme }) => theme.borderRadius};
  display: flex;
  align-items: center;
  justify-content: center;
  position: absolute;
  bottom: ${(9 + 4) / 16}rem; // 9 is the height of the svg and 4 is the padding below
  right: ${({ theme, condensed }) => (condensed ? 0 : theme.spaces[5])};
  transform: ${({ condensed }) => (condensed ? `translateX(50%)` : undefined)};
  z-index: 2;
  width: ${18 / 16}rem;
  height: ${25 / 16}rem;

  svg {
    width: ${6 / 16}rem;
    height: ${9 / 16}rem;
  }
`;
const NavCondense = ({ children, ...props }) => {
    const condensed = MainNavContext.useMainNav();
    return (jsxRuntime.jsxs(NavCondenseWrapper, { as: "button", condensed: condensed, ...props, children: [jsxRuntime.jsx(Icon.Icon, { as: condensed ? icons.ChevronRight : icons.ChevronLeft, "aria-hidden": true, color: "neutral600" }), jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children })] }));
};

exports.NavCondense = NavCondense;
