import { jsx, jsxs } from 'react/jsx-runtime';
import { NavLink } from 'react-router-dom';
import styled from 'styled-components';
import { useMainNav } from './MainNavContext.mjs';
import { Box } from '../Box/Box.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const BrandIconWrapper = styled.div `
  svg,
  img {
    border-radius: ${({ theme }) => theme.borderRadius};
    object-fit: contain;
    height: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
    width: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
  }
`;
const NavLinkWrapper = styled(NavLink) `
  text-decoration: unset;
  color: inherit;
`;
const NavBrand = ({ workplace, title, icon, to = '/' }) => {
    const condensed = useMainNav();
    if (condensed) {
        return (jsx(Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsx(BrandIconWrapper, { condensed: true, children: jsxs(NavLink, { to: to, children: [icon, jsxs(VisuallyHidden, { children: [jsx("span", { children: title }), jsx("span", { children: workplace })] })] }) }) }));
    }
    return (jsx(Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsxs(Flex, { children: [jsx(BrandIconWrapper, { as: NavLink, to: to, "aria-hidden": true, tabIndex: -1, children: icon }), jsxs(Box, { paddingLeft: 2, children: [jsx(Typography, { fontWeight: "bold", textColor: "neutral800", as: "span", children: jsxs(NavLinkWrapper, { to: to, children: [title, jsx(VisuallyHidden, { as: "span", children: workplace })] }) }), jsx(Typography, { variant: "pi", as: "p", textColor: "neutral600", "aria-hidden": true, children: workplace })] })] }) }));
};

export { NavBrand };
