import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { MainNavContext } from './MainNavContext.mjs';
import { Flex } from '../Flex/Flex.mjs';

const MainNavWrapper = styled(Flex) `
  width: ${({ condensed }) => (condensed ? 'max-content' : `${224 / 16}rem`)};
  border-right: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const MainNav = ({ condensed = false, ...props }) => {
    return (jsx(MainNavContext.Provider, { value: condensed, children: jsx(MainNavWrapper, { alignItems: "normal", as: "nav", background: "neutral0", condensed: condensed, direction: "column", height: "100vh", position: "sticky", top: 0, zIndex: 2, ...props }) }));
};

export { MainNav };
