'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const MainNavContext = require('./MainNavContext.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const MainNavWrapper = styled__default.default(Flex.Flex) `
  width: ${({ condensed }) => (condensed ? 'max-content' : `${224 / 16}rem`)};
  border-right: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const MainNav = ({ condensed = false, ...props }) => {
    return (jsxRuntime.jsx(MainNavContext.MainNavContext.Provider, { value: condensed, children: jsxRuntime.jsx(MainNavWrapper, { alignItems: "normal", as: "nav", background: "neutral0", condensed: condensed, direction: "column", height: "100vh", position: "sticky", top: 0, zIndex: 2, ...props }) }));
};

exports.MainNav = MainNav;
