import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';

const MainWrapper = styled(Box) `
  // To prevent global outline on focus visible to force an outline when Main is focused
  &:focus-visible {
    outline: none;
  }
`;
const Main = ({ labelledBy = 'main-content-title', ...props }) => {
    return jsx(MainWrapper, { "aria-labelledby": labelledBy, as: "main", id: "main-content", tabIndex: -1, ...props });
};

export { Main };
