import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled, { keyframes } from 'styled-components';
import loaderSvg from './assets/loader.svg.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';

const rotation = keyframes `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`;
const LoaderImg = styled.img `
  animation: ${rotation} 1s infinite linear;
  will-change: transform;
  ${({ small, theme }) => small && `width: ${theme.spaces[6]}; height: ${theme.spaces[6]};`}
`;
const Loader = React.forwardRef(({ children, small = false, ...props }, ref) => {
    return (jsxs("div", { role: "alert", "aria-live": "assertive", ref: ref, ...props, children: [jsx(VisuallyHidden, { children: children }), jsx(LoaderImg, { src: loaderSvg, "aria-hidden": true, small: small })] }));
});

export { Loader };
