'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const loader = require('./assets/loader.svg.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const rotation = styled.keyframes `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`;
const LoaderImg = styled__default.default.img `
  animation: ${rotation} 1s infinite linear;
  will-change: transform;
  ${({ small, theme }) => small && `width: ${theme.spaces[6]}; height: ${theme.spaces[6]};`}
`;
const Loader = React__namespace.forwardRef(({ children, small = false, ...props }, ref) => {
    return (jsxRuntime.jsxs("div", { role: "alert", "aria-live": "assertive", ref: ref, ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: children }), jsxRuntime.jsx(LoaderImg, { src: loader, "aria-hidden": true, small: small })] }));
});

exports.Loader = Loader;
