'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const reactRouterDom = require('react-router-dom');
const styled = require('styled-components');
const utils = require('../Button/utils.js');
const BaseButton = require('../BaseButton/BaseButton.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const LinkWrapper = styled__default.default(BaseButton.BaseButtonWrapper) `
  &[aria-disabled='true'] {
    ${utils.getDisabledStyle}
    &:active {
      ${utils.getDisabledStyle}
    }
  }
  &:hover {
    ${utils.getHoverStyle}
  }
  &:active {
    ${utils.getActiveStyle}
  }
  ${utils.getVariantStyle}
`;
const LinkButton = React__namespace.forwardRef(({ variant = 'default', startIcon, endIcon, disabled = false, children, size = 'S', href, to, ...props }, ref) => {
    const target = href ? '_blank' : undefined;
    const rel = href ? 'noreferrer noopener' : undefined;
    const paddingX = size === 'S' ? 2 : '10px';
    const paddingY = 4;
    return (jsxRuntime.jsxs(LinkWrapper, { ref: ref, "aria-disabled": disabled, size: size, variant: variant, target: target, rel: rel, to: disabled ? undefined : to, href: disabled ? '#' : href, background: "buttonPrimary600", borderColor: "buttonPrimary600", hasRadius: true, gap: 2, inline: true, paddingBottom: paddingX, paddingLeft: paddingY, paddingRight: paddingY, paddingTop: paddingX, pointerEvents: disabled ? 'none' : undefined, ...props, as: to && !disabled ? reactRouterDom.NavLink : 'a', children: [startIcon && jsxRuntime.jsx(Flex.Flex, { "aria-hidden": true, children: startIcon }), jsxRuntime.jsx(Typography.Typography, { variant: size === 'S' ? 'pi' : undefined, fontWeight: "bold", textColor: "buttonNeutral0", children: children }), endIcon && jsxRuntime.jsx(Flex.Flex, { "aria-hidden": true, children: endIcon })] }));
});

exports.LinkButton = LinkButton;
