import { jsxs, jsx } from 'react/jsx-runtime';
import { Grid } from '../Grid/Grid.mjs';
import { GridItem } from '../Grid/GridItem.mjs';
import { Box } from '../Box/Box.mjs';

const TwoColsLayout = ({ startCol, endCol }) => {
    return (jsxs(Grid, { gap: 4, children: [jsx(GridItem, { col: 9, s: 12, children: jsx(Box, { hasRadius: true, background: "neutral0", shadow: "tableShadow", children: startCol }) }), jsx(GridItem, { col: 3, s: 12, children: jsx(Box, { hasRadius: true, background: "neutral0", shadow: "tableShadow", children: endCol }) })] }));
};

export { TwoColsLayout };
