import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import React__default, { useRef, useState, useEffect } from 'react';
import styled from 'styled-components';
import { useElementOnScreen } from '../hooks/useElementOnScreen.mjs';
import { useResizeObserver } from '../hooks/useResizeObserver.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const HeaderLayout = (props) => {
    const baseHeaderLayoutRef = useRef(null);
    const [headerSize, setHeaderSize] = useState(null);
    const [containerRef, isVisible] = useElementOnScreen({
        root: null,
        rootMargin: '0px',
        threshold: 0,
    });
    useResizeObserver(containerRef, () => {
        if (containerRef.current) {
            setHeaderSize(containerRef.current.getBoundingClientRect());
        }
    });
    useEffect(() => {
        if (baseHeaderLayoutRef.current) {
            setHeaderSize(baseHeaderLayoutRef.current.getBoundingClientRect());
        }
    }, [baseHeaderLayoutRef]);
    return (jsxs(Fragment, { children: [jsx("div", { style: { height: headerSize?.height }, ref: containerRef, children: isVisible && jsx(BaseHeaderLayout, { ref: baseHeaderLayoutRef, ...props }) }), !isVisible && jsx(BaseHeaderLayout, { ...props, sticky: true, width: headerSize?.width })] }));
};
HeaderLayout.displayName = 'HeaderLayout';
const StickyBox = styled(Box) `
  width: ${({ width }) => (width ? `${width / 16}rem` : undefined)};
  z-index: ${({ theme }) => theme.zIndices[1]};
`;
const BaseHeaderLayout = React__default.forwardRef(({ navigationAction, primaryAction, secondaryAction, subtitle, title, sticky, width, ...props }, ref) => {
    const isSubtitleString = typeof subtitle === 'string';
    if (sticky) {
        return (jsx(StickyBox, { paddingLeft: 6, paddingRight: 6, paddingTop: 3, paddingBottom: 3, position: "fixed", top: 0, right: 0, background: "neutral0", shadow: "tableShadow", width: width, "data-strapi-header-sticky": true, children: jsxs(Flex, { justifyContent: "space-between", children: [jsxs(Flex, { children: [navigationAction && jsx(Box, { paddingRight: 3, children: navigationAction }), jsxs(Box, { children: [jsx(Typography, { variant: "beta", as: "h1", ...props, children: title }), isSubtitleString ? (jsx(Typography, { variant: "pi", textColor: "neutral600", children: subtitle })) : (subtitle)] }), secondaryAction ? jsx(Box, { paddingLeft: 4, children: secondaryAction }) : null] }), jsx(Flex, { children: primaryAction ? jsx(Box, { paddingLeft: 2, children: primaryAction }) : undefined })] }) }));
    }
    return (jsxs(Box, { ref: ref, paddingLeft: 10, paddingRight: 10, paddingBottom: 8, paddingTop: navigationAction ? 6 : 8, background: "neutral100", "data-strapi-header": true, children: [navigationAction ? jsx(Box, { paddingBottom: 2, children: navigationAction }) : null, jsxs(Flex, { justifyContent: "space-between", children: [jsxs(Flex, { minWidth: 0, children: [jsx(Typography, { as: "h1", variant: "alpha", ...props, children: title }), secondaryAction ? jsx(Box, { paddingLeft: 4, children: secondaryAction }) : null] }), primaryAction] }), isSubtitleString ? (jsx(Typography, { variant: "epsilon", textColor: "neutral600", as: "p", children: subtitle })) : (subtitle)] }));
});

export { BaseHeaderLayout, HeaderLayout };
