import { jsxs, jsx } from 'react/jsx-runtime';
import { Flex } from '../Flex/Flex.mjs';

const ActionLayout = ({ startActions, endActions }) => {
    if (!startActions && !endActions) {
        return null;
    }
    return (jsxs(Flex, { justifyContent: "space-between", alignItems: "flex-start", paddingBottom: 4, paddingLeft: 10, paddingRight: 10, children: [jsx(Flex, { gap: 2, wrap: "wrap", children: startActions }), jsx(Flex, { gap: 2, shrink: 0, wrap: "wrap", children: endActions })] }));
};

export { ActionLayout };
