import { jsx } from 'react/jsx-runtime';
import { useField } from './FieldContext.mjs';
import { Typography } from '../Typography/Typography.mjs';

const FieldError = () => {
    const { id, error } = useField();
    if (!error || typeof error !== 'string') {
        return null;
    }
    return (jsx(Typography, { variant: "pi", as: "p", id: `${id}-error`, textColor: "danger600", "data-strapi-field-error": true, children: error }));
};

export { FieldError };
