'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const FieldContext = require('./FieldContext.js');
const Typography = require('../Typography/Typography.js');

const FieldError = () => {
    const { id, error } = FieldContext.useField();
    if (!error || typeof error !== 'string') {
        return null;
    }
    return (jsxRuntime.jsx(Typography.Typography, { variant: "pi", as: "p", id: `${id}-error`, textColor: "danger600", "data-strapi-field-error": true, children: error }));
};

exports.FieldError = FieldError;
