'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const Flex = require('../Flex/Flex.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const FieldActionWrapper = styled__default.default(Flex.Flex) `
  font-size: 1.6rem;
  padding: 0;
`;
const FieldAction = React.forwardRef(({ label, children, ...props }, ref) => (jsxRuntime.jsxs(FieldActionWrapper, { justifyContent: "unset", background: "transparent", borderStyle: "none", type: "button", ...props, as: "button", ref: ref, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { as: "span", children: label }), React.cloneElement(children, {
            'aria-hidden': true,
            focusable: false, // See: https://allyjs.io/tutorials/focusing-in-svg.html#making-svg-elements-focusable
        })] })));

exports.FieldAction = FieldAction;
